<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Admin\GameController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Admin\WalletButtonController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\WalletController;
use App\Http\Controllers\RulesController;
use App\Http\Controllers\PromoController;
use App\Http\Controllers\Admin\PromoController as AdminPromoController;
use App\Http\Controllers\Admin\LogController;

// Redirect based on user role after login
Route::middleware(['auth', 'role:customer', 'check.status'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('customer.dashboard');

    // Profile Routes (Customer specific)
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Payment Routes
    Route::get('/addpoints', [PaymentController::class, 'showPaymentForm'])->name('payment.form');
    Route::post('/addpoints/generate-address', [PaymentController::class, 'generateBitcoinAddress'])->name('payment.generate.address');
    Route::post('/addpoints/generate-address-usdt', [PaymentController::class, 'generateUSDTAddress'])->name('payment.generate.address.usdt');
    Route::post('/addpoints/generate-address-usdc', [PaymentController::class, 'generateUSDCAddress'])->name('payment.generate.address.usdc');
    Route::get('/addpoints/status/{paymentId}', [PaymentController::class, 'checkStatus'])->name('payment.status');
    Route::post('/addpoints/remove', [PaymentController::class, 'removeOldTryspeedTransaction'])->name('payment.remove');
    Route::get('/addpoints/success/{paymentId}', [PaymentController::class, 'success'])->name('payment.success');
    Route::get('/payment/status/{orderId}', [PaymentController::class, 'ggpayoutSuccess'])->name('payment.ggpayout.success');
    Route::post('/payment/ecashapp/fill', [PaymentController::class, 'fillEcashappOrder'])->name('payment.ecashapp.fill');

     // Payken routes
     Route::post('/addpoints/payken-create', [PaymentController::class, 'createPaykenOrder'])->name('payment.payken.create');
     Route::get('/payment/payken/callback', [PaymentController::class, 'handlePaykenCallback'])->name('payment.payken.callback');

    // Redeem Routes
    Route::get('/redeempoints', [PaymentController::class, 'showRedeemForm'])->name('redeem.form');
    Route::post('/redeempoints/process', [PaymentController::class, 'processRedeemRequest'])->name('redeem.process');
    Route::get('/redeempoints/success/{transactionId}', [PaymentController::class, 'redeemSuccess'])->name('redeem.success');

    // Rules Route
    Route::get('/rules', [RulesController::class, 'index'])->name('rules');
    
    // Promo Route
    Route::get('/promo', [PromoController::class, 'index'])->name('promo');
});

// Admin and Cashier Dashboard Access
Route::middleware(['auth', 'role:admin,cashier', 'check.status'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    // Profile Management Routes (Admin and Cashier)
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Admin Only Routes
Route::middleware(['auth', 'verified', 'role:admin', 'check.status'])->prefix('admin')->name('admin.')->group(function () {
    Route::resource('/games', GameController::class);
    Route::patch('/games/{game}/toggle-status', [GameController::class, 'toggleStatus'])->name('games.toggle-status');
    Route::resource('/users', UserController::class);
    Route::patch('/users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggle-status');
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingController::class, 'update'])->name('settings.update');
    Route::resource('wallet-buttons', WalletButtonController::class);
    Route::put('/wallet-buttons/update-order', [WalletButtonController::class, 'updateOrder'])->name('wallet-buttons.update-order');
    Route::put('/wallet-buttons/{walletButton}/toggle-status', [WalletButtonController::class, 'toggleStatus'])->name('wallet-buttons.toggle-status');
    Route::get('/wallet', [WalletController::class, 'index'])->name('wallet.index');
     
    // Logs routes
    Route::resource('logs', LogController::class)->only(['index', 'show']);
    Route::post('logs/clear', [LogController::class, 'clear'])->name('logs.clear');
    Route::post('logs/export', [LogController::class, 'export'])->name('logs.export');
    Route::get('logs/stats', [LogController::class, 'stats'])->name('logs.stats');
    Route::get('logs/debug', [LogController::class, 'debug'])->name('logs.debug');
    
    // Promo Management
    Route::resource('promos', AdminPromoController::class);
});

// Admin and Cashier Transaction Routes
Route::middleware(['auth', 'role:admin,cashier', 'check.status'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/transaction-stats', function () {
        return Inertia::render('Admin/TransactionStats');
    })->name('transaction-stats');
    Route::resource('transactions', TransactionController::class)->only(['index', 'show']);
    Route::patch('transactions/{transaction}/status', [TransactionController::class, 'updateStatus'])->name('transactions.update-status');
    Route::get('transaction-stats/api', [DashboardController::class, 'getTransactionStats'])->name('transaction-stats.api');
    Route::get('transaction-stats/compare', [DashboardController::class, 'getPeriodComparison'])->name('transaction-stats.compare');

    // Customer Transaction Statistics Routes
    Route::get('customer-transaction-stats', function () {
        return Inertia::render('Admin/CustomerTransactionStats');
    })->name('customer-transaction-stats');
    Route::get('customer-transaction-stats/api', [DashboardController::class, 'getCustomerTransactionStats'])->name('customer-transaction-stats.api');
    Route::get('customer-transaction-history/{customerId}', [DashboardController::class, 'getCustomerTransactionHistory'])->name('customer-transaction-history');
    Route::get('customer-transaction-history/{customerId}/view', [DashboardController::class, 'showCustomerTransactionHistory'])->name('customer-transaction-history.view');
    Route::get('customer-transaction-history/{customerId}/download', [DashboardController::class, 'downloadCustomerTransactionReport'])->name('customer-transaction-history.download');
});

// IDN No Generation
Route::get('/generate-idn-no', [RegisteredUserController::class, 'generateIdnNo'])->name('generate.idn_no');


Route::get('/setup-webhook/{key}', function ($key) {
    if ($key !== config('app.webhook_secret')) {
        abort(403);
    }
    Artisan::call('telegram:setup-webhook');
    return response()->json(['status' => 'Webhook setup executed']);
});


Route::post('/addpoints/ggpayout-create', [PaymentController::class, 'createGGPayoutOrder'])
    ->middleware(['auth']);

require __DIR__.'/auth.php';
