import { Head, Link } from '@inertiajs/react';
import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';

export default function Promo({ auth, promos, settings }) {
    return (
        <AuthenticatedLayout
            user={auth.user}
            settings={settings}
            header={<h2 className="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">Promotions</h2>}
        >
            <Head title="Promotions" />

            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    {/* Header Section */}
                    <div className="mb-8">
                        <div className="bg-gradient-to-r from-[#FF6F00] to-[#960018] rounded-2xl p-8 text-center">
                            <div className="flex items-center justify-center space-x-3 mb-4">
                                <div className="bg-white/20 rounded-full p-3">
                                    <svg className="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7" />
                                    </svg>
                                </div>
                                <div>
                                    <h1 className="text-3xl font-bold text-white">Special Promotions</h1>
                                    <p className="text-purple-100 text-lg mt-1">Discover amazing offers and deals</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Promos Grid */}
                    {promos.length > 0 ? (
                        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                            {promos.map((promo) => (
                                <div key={promo.id} className="bg-white dark:bg-gray-800 overflow-hidden shadow-xl rounded-2xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2">
                                    {/* Image Section */}
                                    <Link href={route('payment.form')} className="block">
                                        <div className="relative h-48 overflow-hidden">
                                            <img
                                                src={promo.image_path ? `/storage/${promo.image_path}` : '/placeholder-image.jpg'}
                                                alt={promo.image_alt || promo.title}
                                                className="w-full h-full object-cover transition-transform duration-300 hover:scale-110"
                                            />
                                            {promo.start_date && promo.end_date && (
                                                <div className="absolute top-4 right-4 bg-[#FF6F00] text-white px-3 py-1 rounded-full text-xs font-semibold">
                                                    Limited Time
                                                </div>
                                            )}
                                        </div>

                                        {/* Content Section */}
                                        <div className="p-6">
                                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-3">
                                                {promo.title}
                                            </h3>
                                            
                                            <div className="prose prose-sm dark:prose-invert max-w-none mb-4">
                                                <div 
                                                    className="text-gray-600 dark:text-gray-300 leading-relaxed"
                                                    dangerouslySetInnerHTML={{ __html: promo.description }}
                                                />
                                            </div>

                                            {/* Date Range */}
                                            {(promo.start_date || promo.end_date) && (
                                                <div className="mt-4 pt-4 border-t border-gray-200 dark:border-gray-600">
                                                    <div className="flex items-center space-x-2 text-sm text-gray-500 dark:text-gray-400">
                                                        <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                        </svg>
                                                        <span>
                                                            {promo.start_date && promo.end_date 
                                                                ? `${new Date(promo.start_date).toLocaleDateString()} - ${new Date(promo.end_date).toLocaleDateString()}`
                                                                : promo.start_date 
                                                                    ? `From ${new Date(promo.start_date).toLocaleDateString()}`
                                                                    : `Until ${new Date(promo.end_date).toLocaleDateString()}`
                                                            }
                                                        </span>
                                                    </div>
                                                </div>
                                            )}
                                        </div>
                                    </Link>
                                </div>
                            ))}
                        </div>
                    ) : (
                        /* Empty State */
                        <div className="text-center py-12">
                            <div className="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-lg">
                                <div className="flex items-center justify-center mb-4">
                                    <div className="bg-gray-100 dark:bg-gray-700 rounded-full p-4">
                                        <svg className="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7" />
                                        </svg>
                                    </div>
                                </div>
                                <h3 className="text-xl font-semibold text-gray-900 dark:text-white mb-2">
                                    No Promotions Available
                                </h3>
                                <p className="text-gray-600 dark:text-gray-400">
                                    Check back later for exciting promotions and special offers!
                                </p>
                            </div>
                        </div>
                    )}
                </div>
            </div>

            <style jsx>{`
                .prose {
                    line-height: 1.6;
                }
                
                .prose h1, .prose h2, .prose h3, .prose h4 {
                    color: #374151;
                    font-weight: 600;
                    margin-bottom: 0.5rem;
                    margin-top: 1rem;
                }
                
                .prose p {
                    margin-bottom: 0.75rem;
                    color: #6b7280;
                }
                
                .prose ul, .prose ol {
                    margin-bottom: 0.75rem;
                    padding-left: 1.25rem;
                }
                
                .prose li {
                    margin-bottom: 0.25rem;
                    color: #6b7280;
                }
                
                .prose strong {
                    color: #374151;
                    font-weight: 600;
                }
                
                .dark .prose h1, .dark .prose h2, .dark .prose h3, .dark .prose h4 {
                    color: #e5e7eb;
                }
                
                .dark .prose p {
                    color: #d1d5db;
                }
                
                .dark .prose li {
                    color: #d1d5db;
                }
                
                .dark .prose strong {
                    color: #e5e7eb;
                }
            `}</style>
        </AuthenticatedLayout>
    );
} 