import AdminLayout from '@/Layouts/AdminLayout';
import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import DeleteUserForm from './Partials/DeleteUserForm';
import UpdatePasswordForm from './Partials/UpdatePasswordForm';
import UpdateProfileInformationForm from './Partials/UpdateProfileInformationForm';
import { Head, usePage } from '@inertiajs/react';

export default function Edit({ auth, mustVerifyEmail, status, settings }) {
    const { auth: { user } } = usePage().props;
    const isAdmin = user.role === 'admin';
    const isCashier = user.role === 'cashier';

    // Common content for both layouts
    const content = (
        <>
            <Head title="Profile" />

            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
                    {(isAdmin || isCashier) && (
                        <div className="bg-gradient-to-r from-[#d34a40] to-[#b03a30] dark:from-[#73100d] dark:to-[#590c0a] overflow-hidden shadow-lg rounded-[15px]">
                            <div className="p-6 text-white">
                                <h1 className="text-3xl font-bold mb-2">Profile Management</h1>
                                <p className="text-gray-100 dark:text-gray-200">
                                    Manage your {isAdmin ? 'admin' : 'cashier'} profile information and settings
                                </p>
                            </div>
                        </div>
                    )}

                    <div className={`p-4 sm:p-8 bg-white dark:bg-gray-800 shadow ${isAdmin || isCashier ? 'rounded-[15px] border border-gray-200 dark:border-gray-700' : 'sm:rounded-lg'}`}>
                        <UpdateProfileInformationForm
                            mustVerifyEmail={mustVerifyEmail}
                            status={status}
                            className="max-w-xl"
                        />
                    </div>

                    <div className={`p-4 sm:p-8 bg-white dark:bg-gray-800 shadow ${isAdmin || isCashier ? 'rounded-[15px] border border-gray-200 dark:border-gray-700' : 'sm:rounded-lg'}`}>
                        <UpdatePasswordForm className="max-w-xl" />
                    </div>

                    <div className={`p-4 sm:p-8 bg-white dark:bg-gray-800 shadow ${isAdmin || isCashier ? 'rounded-[15px] border border-gray-200 dark:border-gray-700' : 'sm:rounded-lg'}`}>
                        <DeleteUserForm className="max-w-xl" />
                    </div>
                </div>
            </div>
        </>
    );

    // Return appropriate layout based on role
    if (isAdmin || isCashier) {
        return <AdminLayout>{content}</AdminLayout>;
    }

    return (
        <AuthenticatedLayout
            settings={settings}
            user={auth.user}
            header={<h2 className="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">Profile</h2>}
        >
            {content}
        </AuthenticatedLayout>
    );
}
