import React from 'react';
import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link } from '@inertiajs/react';
import FormatDate from '@/Components/FormatDate';

export default function PaymentSuccess({ auth, transaction, settings }) {
    return (
        <AuthenticatedLayout user={auth.user} settings={settings}>
            <Head title="Payment Success" />
            <div className="flex items-center justify-center min-h-screen bg-gray-50 dark:bg-gray-900">
                <div className="max-w-md w-full p-6 bg-white dark:bg-gray-800 rounded-lg shadow-md text-center">
                    <h1 className="text-2xl font-bold text-green-600">Payment Successful!</h1>
                    <p className="mt-2 text-gray-700 dark:text-gray-300">
                        Your payment has been successfully processed. Here are the details:
                    </p>

                    <div className="mt-4 bg-gray-100 dark:bg-gray-700 p-4 rounded-lg text-left">
                        <p><strong>Invoice ID:</strong> {transaction.invoice_id}</p>
                        <p><strong>Amount:</strong> {transaction.amount} {transaction.currency}</p>
                        <p className="capitalize"><strong>Status:</strong> 
                            <span className={`ml-2 px-2 py-1 rounded text-white ${
                                transaction.payment_status === 'paid' ? 'bg-green-500' :
                                transaction.payment_status === 'unpaid' ? 'bg-yellow-500' : 
                                transaction.payment_status === 'expired' ? 'bg-gray-300' : 
                                'bg-red-500'
                            }`}>
                                {transaction.payment_status}
                            </span>
                        </p>
                        <p className="capitalize"><strong>Payment Method:</strong> {transaction.payment_method}</p>
                        <p><strong>Date:</strong> <FormatDate createdAt={transaction.created_at} /></p>
                    </div>

                    <Link href={route('customer.dashboard')} className="mt-4 inline-block bg-[#FF6F00] text-white font-bold py-2 px-4 rounded hover:bg-[#960018] transition-all duration-300">
                        Go to Dashboard
                    </Link>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
