import React, { memo } from 'react';

const WalletButtonItem = memo(function WalletButtonItem({ button, provided, onEdit, onDelete, onToggleStatus }) {
    return (
        <div
            ref={provided.innerRef}
            {...provided.draggableProps}
            {...provided.dragHandleProps}
            className="flex flex-col sm:flex-row items-start sm:items-center justify-between p-4 bg-gray-50 dark:bg-gray-700 rounded-lg transition-colors hover:bg-gray-100 dark:hover:bg-gray-600 space-y-4 sm:space-y-0"
        >
            <div className="flex items-center space-x-4 w-full sm:w-auto">
                <img
                    src={`/storage/${button.icon_url}`}
                    alt={button.name}
                    className="w-8 h-8 sm:w-10 sm:h-10 object-contain rounded bg-white"
                />
                <div>
                    <h3 className="font-semibold text-gray-900 dark:text-gray-100 text-sm sm:text-base">
                        {button.name}
                    </h3>
                    <p className="text-xs sm:text-sm text-gray-500 dark:text-gray-400">
                        Type: {button.type.charAt(0).toUpperCase() + button.type.slice(1)}
                    </p>
                </div>
            </div>
            <div className="flex items-center space-x-2 w-full sm:w-auto justify-end">
                <button
                    onClick={onToggleStatus}
                    className={`
                        px-2 sm:px-3 py-1 rounded-md transition-colors text-xs sm:text-sm
                        ${button.is_enabled 
                            ? 'bg-green-100 text-green-800 hover:bg-green-200' 
                            : 'bg-red-100 text-red-800 hover:bg-red-200'}
                    `}
                >
                    {button.is_enabled ? 'Enabled' : 'Disabled'}
                </button>
                <button
                    onClick={onEdit}
                    className="p-1.5 sm:p-2 text-blue-600 hover:text-blue-800 transition-colors"
                    title="Edit"
                >
                    <svg className="w-4 h-4 sm:w-5 sm:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                    </svg>
                </button>
                <button
                    onClick={onDelete}
                    className="p-1.5 sm:p-2 text-red-600 hover:text-red-800 transition-colors"
                    title="Delete"
                >
                    <svg className="w-4 h-4 sm:w-5 sm:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                    </svg>
                </button>
            </div>
        </div>
    );
});

WalletButtonItem.displayName = 'WalletButtonItem';

export default WalletButtonItem; 