import AdminLayout from '@/Layouts/AdminLayout';
import { Head } from '@inertiajs/react';
import UserForm from './Form';

export default function Create({idn_no}) {
    return (
        <AdminLayout>
            <Head title="Create User" />

            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    {/* Header Section */}
                    <div className="bg-gradient-to-r from-[#d34a40] to-[#b03a30] dark:from-[#73100d] dark:to-[#590c0a] p-6 rounded-[15px] shadow-lg mb-6">
                        <h1 className="text-3xl font-bold text-white">Create New User</h1>
                        <p className="text-gray-100 dark:text-gray-200 mt-2">Add a new user to the system</p>
                    </div>

                    {/* Form Section */}
                    <div className="bg-white dark:bg-gray-800 rounded-[15px] shadow-lg p-6">
                        <UserForm idn_no={idn_no} />
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
} 