import React from 'react';
import AdminLayout from '@/Layouts/AdminLayout';
import { Head, Link } from '@inertiajs/react';

const Show = ({ game }) => {
    return (
        <AdminLayout>
            <Head title={game.game_name} />
            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    {/* Header Section */}
                    <div className="bg-gradient-to-r from-[#d34a40] to-[#b03a30] dark:from-[#73100d] dark:to-[#590c0a] p-6 rounded-[15px] shadow-lg mb-6">
                        <h1 className="text-3xl font-bold text-white">{game.game_name}</h1>
                        <p className="text-gray-100 dark:text-gray-200 mt-2">Game Details and Information</p>
                    </div>

                    <div className="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-[15px] border border-gray-200 dark:border-gray-700">
                        <div className="p-6">
                            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                                {/* Image Section */}
                                <div>
                                    {game.game_image && (
                                        <div className="relative group">
                                            <img 
                                                src={`/storage/${game.game_image}`} 
                                                alt={game.game_name} 
                                                className="w-full h-auto rounded-lg shadow-md border border-gray-200 dark:border-gray-700 dark:opacity-90" 
                                            />
                                            <div className="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-10 transition-all duration-300 rounded-lg"></div>
                                        </div>
                                    )}
                                </div>

                                {/* Details Section */}
                                <div className="space-y-4">
                                    <div>
                                        <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-2">Game Details</h2>
                                        <div className="space-y-3">
                                            <div>
                                                <span className="text-gray-600 dark:text-gray-400">Status: </span>
                                                <span className={`inline-flex items-center px-3 py-1 rounded-full text-sm font-medium ${
                                                    game.status === 'active' 
                                                        ? 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400'
                                                        : 'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400'
                                                }`}>
                                                    {game.status}
                                                </span>
                                            </div>
                                            <div>
                                                <span className="text-gray-600 dark:text-gray-400">Created: </span>
                                                <span className="text-gray-900 dark:text-white">{new Date(game.created_at).toLocaleDateString()}</span>
                                            </div>
                                            <div>
                                                <span className="text-gray-600 dark:text-gray-400">Last Updated: </span>
                                                <span className="text-gray-900 dark:text-white">{new Date(game.updated_at).toLocaleDateString()}</span>
                                            </div>
                                        </div>
                                    </div>

                                    <div className="flex gap-4 pt-4">
                                        <Link
                                            href={route('admin.games.edit', game.id)}
                                            className="inline-flex items-center px-4 py-2 bg-[#d34a40] dark:bg-[#73100d] text-white rounded-lg hover:bg-[#b03a30] dark:hover:bg-[#590c0a] transition-colors"
                                        >
                                            <i className="fas fa-edit mr-2"></i>
                                            Edit Game
                                        </Link>
                                        <Link
                                            href={route('admin.games.index')}
                                            className="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-700 rounded-lg text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors"
                                        >
                                            <i className="fas fa-arrow-left mr-2"></i>
                                            Back to Games
                                        </Link>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
};

export default Show;
