import ApplicationLogo from '@/Components/ApplicationLogo';
import { Link } from '@inertiajs/react';
import { useState } from 'react';
import ThemeToggle from '@/Components/ThemeToggle';

export default function Guest({ children }) {

    return (
        <div className={`bg-gray-50 dark:bg-gray-900 font-[sans-serif]`}>
            <div className="min-h-screen flex flex-col items-center justify-center py-6 px-4">
                <div className="max-w-md w-full">
                    <Link href={route('customer.dashboard')}>
                        <ApplicationLogo className="w-20 mb-8 mx-auto block" />
                    </Link>
                    {children}
                </div>
            </div>

            <ThemeToggle />
        </div>
    );
}
