import React from 'react';
import { useTheme } from '../ThemeContext';
import '@fortawesome/fontawesome-free/css/all.css';

const ThemeToggle = () => {
    const { isDarkMode, toggleDarkMode } = useTheme();

    return (
        <button
            onClick={toggleDarkMode}
            className="fixed bottom-20 right-4 p-3 w-[50px] rounded bg-gray-800 dark:bg-gray-800 text-[#f1c40f] dark:text-[#f1c40f] shadow-lg flex items-center justify-center z-10"
            aria-label="Toggle Dark Mode"
        >
            {isDarkMode ? (
                <i className="fas fa-sun text-xl"></i>
            ) : (
                <i className="fas fa-moon text-xl"></i>
            )}
        </button>
    );
};

export default ThemeToggle; 