import React, { createContext, useContext, useState, useEffect } from 'react';
import { router } from '@inertiajs/react';
import Loader from './Loader';

const LoadingContext = createContext();

export function useLoading() {
    return useContext(LoadingContext);
}

export function LoadingProvider({ children }) {
    const [isLoading, setIsLoading] = useState(false);

    useEffect(() => {
        router.on('start', () => setIsLoading(true));
        router.on('finish', () => setIsLoading(false));

        return () => {
            router.off('start');
            router.off('finish');
        };
    }, []);

    return (
        <LoadingContext.Provider value={{ isLoading, setIsLoading }}>
            {isLoading && <Loader />}
            {children}
        </LoadingContext.Provider>
    );
} 