import React from 'react';
import { useTheme } from '@/ThemeContext';

export default function Loader() {
    const { isDarkMode } = useTheme();
    
    return (
        <div className="fixed inset-0 z-[9999] flex items-center justify-center bg-white/50 dark:bg-gray-900/50 backdrop-blur-sm transition-colors duration-200">
            <div className="relative bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-2xl flex flex-col items-center space-y-4 border border-gray-100 dark:border-gray-700 transition-all duration-200">
                {/* Logo/Brand Section */}
                <div className="absolute -top-12 left-1/2 -translate-x-1/2 bg-white dark:bg-gray-800 rounded-full p-3 shadow-lg border border-gray-100 dark:border-gray-700">
                    <div className="w-10 h-10 rounded-full bg-[#FF6F00] dark:bg-[#960018]"></div>
                </div>

                {/* Spinner Section */}
                <div className="relative w-16 h-16 mt-4">
                    {/* Outer Ring with Background */}
                    <div className="absolute inset-0 rounded-full border-4 border-gray-100 dark:border-gray-700"></div>
                    <div className="absolute inset-0 rounded-full border-4 border-[#FF6F00] dark:border-[#960018] border-t-transparent animate-spin"></div>
                    
                    {/* Middle Ring with Background */}
                    <div className="absolute inset-[4px] rounded-full border-4 border-gray-50 dark:border-gray-600"></div>
                    <div className="absolute inset-[4px] rounded-full border-4 border-[#FF6F00] dark:border-[#960018] border-t-transparent animate-spin" 
                         style={{ animationDirection: 'reverse', animationDuration: '1s' }}></div>
                    
                    {/* Center Circle */}
                    <div className="absolute inset-[8px] rounded-full bg-[#FF6F00] dark:bg-[#960018] animate-pulse shadow-lg"></div>
                </div>
                
                {/* Text Section */}
                <div className="text-center space-y-1">
                    <h3 className="text-gray-800 dark:text-gray-100 text-lg font-semibold">Loading...</h3>
                    <p className="text-gray-500 dark:text-gray-400 text-sm">Please wait while we process your request</p>
                </div>
            </div>
        </div>
    );
} 