import React, { Component } from "react";
import "./SwipeableButton.css";
interface SwipeableButtonProps {
    autoWidth?: boolean;
    circle?: boolean;
    disabled?: boolean;
    noAnimate?: boolean;
    width?: number;
    height?: number;
    position?: number;
    text?: string;
    text_unlocked?: string;
    name?: string;
    onSuccess?: () => void;
    onFailure?: () => void;
    sliderColor?: string;
    sliderTextColor?: string;
    textColor?: string;
    sliderIconColor?: string;
    background_color?: string;
    borderRadius?: number;
    /**
     * @deprecated Deprecation Warning: The 'color' prop is deprecated and will be removed in future versions. Please use 'sliderColor' instead.
     */
    color?: string;
    buttonChildren?: React.ReactNode;
    buttonChildrenUnlocked?: React.ReactNode;
}
interface SwipeableButtonState {
    unlocked: boolean;
}
export interface SwipeableButtonRef {
    buttonReset: () => void;
    buttonComplete: () => void;
}
export default class SwipeableButton extends Component<SwipeableButtonProps, SwipeableButtonState> {
    private sliderLeft;
    private isDragging;
    private startX;
    private containerWidth;
    private sliderRef;
    private containerRef;
    constructor(props: SwipeableButtonProps);
    componentDidMount(): void;
    componentWillUnmount(): void;
    private onDrag;
    private updateSliderStyle;
    private stopDrag;
    private startDrag;
    private onSwiped;
    private getText;
    buttonReset: () => void;
    buttonComplete: () => void;
    render(): React.JSX.Element;
}
export {};
