import {
  require_react
} from "./chunk-DRWLMN53.js";
import {
  __toESM
} from "./chunk-G3PMV62Z.js";

// node_modules/react-swipeable-button/dist/esm/components/SwipeableButton.js
var import_react = __toESM(require_react());
import "D:/jack/fishgames/node_modules/react-swipeable-button/dist/esm/components/SwipeableButton.css";
var SwipeableButton = class extends import_react.Component {
  constructor(props) {
    super(props);
    this.sliderLeft = 0;
    this.isDragging = false;
    this.startX = 0;
    this.containerWidth = 0;
    this.sliderRef = import_react.default.createRef();
    this.containerRef = import_react.default.createRef();
    this.onDrag = (e) => {
      if (this.state.unlocked || this.props.disabled) {
        return;
      }
      if (this.isDragging) {
        const clientX = "touches" in e ? e.touches[0].clientX : e.clientX;
        this.sliderLeft = Math.min(Math.max(0, clientX - this.startX), this.containerWidth);
        this.updateSliderStyle();
      }
    };
    this.updateSliderStyle = () => {
      if (this.state.unlocked)
        return;
      if (this.sliderRef.current) {
        this.sliderRef.current.style.left = `${this.sliderLeft + 50}px`;
      }
    };
    this.stopDrag = () => {
      if (this.state.unlocked)
        return;
      if (this.isDragging) {
        this.isDragging = false;
        if (this.sliderLeft > this.containerWidth * 0.9) {
          this.sliderLeft = this.containerWidth;
          this.onSwiped();
        } else {
          this.sliderLeft = 0;
          if (this.props.onFailure) {
            this.props.onFailure();
          }
        }
        this.updateSliderStyle();
      }
    };
    this.startDrag = (e) => {
      if (this.state.unlocked)
        return;
      this.isDragging = true;
      this.startX = "touches" in e ? e.touches[0].clientX : e.clientX;
    };
    this.onSwiped = () => {
      if (this.containerRef.current) {
        this.containerRef.current.style.width = `${this.containerRef.current.clientWidth}px`;
      }
      this.setState({
        unlocked: true
      }, () => {
        if (this.props.onSuccess) {
          this.props.onSuccess();
        }
      });
    };
    this.getText = () => {
      return this.state.unlocked ? this.props.text_unlocked || "UNLOCKED!" : this.props.text || "SWIPE";
    };
    this.buttonReset = () => {
      if (!this.state.unlocked)
        return;
      this.setState({ unlocked: false }, () => {
        this.sliderLeft = 0;
        this.updateSliderStyle();
      });
    };
    this.buttonComplete = () => {
      if (this.state.unlocked)
        return;
      this.sliderLeft = this.containerWidth;
      this.updateSliderStyle();
      this.onSwiped();
    };
    this.state = {
      unlocked: false
    };
  }
  componentDidMount() {
    if (this.containerRef.current) {
      const containerWidth = () => {
        if (this.containerRef.current) {
          this.containerWidth = this.containerRef.current.clientWidth - 50;
        }
      };
      containerWidth();
      setTimeout(() => {
        containerWidth();
      }, 250);
    }
    document.addEventListener("mousemove", this.onDrag);
    document.addEventListener("mouseup", this.stopDrag);
    document.addEventListener("touchmove", this.onDrag);
    document.addEventListener("touchend", this.stopDrag);
  }
  componentWillUnmount() {
    document.removeEventListener("mousemove", this.onDrag);
    document.removeEventListener("mouseup", this.stopDrag);
    document.removeEventListener("touchmove", this.onDrag);
    document.removeEventListener("touchend", this.stopDrag);
  }
  render() {
    const { width = 300, height = 50, circle = true, disabled = false, noAnimate = false, autoWidth = false, name = "react-swipeable-button", color, sliderColor, background_color = "#eee", borderRadius = 30, sliderTextColor = "#fff", sliderIconColor = "#fff", textColor = "#000", buttonChildren, buttonChildrenUnlocked } = this.props;
    const finalSliderColor = sliderColor || color || "#16362d";
    if (color && !sliderColor) {
      console.warn("Deprecation Warning: The 'color' prop is deprecated and will be removed in future versions. Please use 'sliderColor' instead.");
    }
    return import_react.default.createElement(
      "div",
      { key: name, className: `ReactSwipeButton ${disabled ? "rsbContainerDisabled" : ""}`, style: {
        width: autoWidth ? "100%" : `${width}px`,
        height: `${height}px`
      } },
      import_react.default.createElement(
        "div",
        { className: `rsbContainer ${this.state.unlocked ? "rsbContainerUnlocked" : ""} `, ref: this.containerRef, style: {
          borderRadius: circle ? "50px" : "5px",
          backgroundColor: background_color
        } },
        !noAnimate && !disabled && !this.state.unlocked && import_react.default.createElement("div", { className: "sliderShimmer" }),
        import_react.default.createElement(
          "div",
          { className: `rsbcSlider`, ref: this.sliderRef, onMouseDown: this.startDrag, style: {
            background: finalSliderColor,
            borderRadius: circle ? `${borderRadius}px` : "0px"
          }, onTouchStart: this.startDrag },
          buttonChildren ? import_react.default.createElement("div", { style: {
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
            height: "100%"
          } }, this.state.unlocked && buttonChildrenUnlocked ? buttonChildrenUnlocked : buttonChildren) : import_react.default.createElement("span", { className: `rsbcSliderText ${noAnimate || this.state.unlocked || disabled ? "" : "textAnimate"}`, style: { color: sliderTextColor } }, this.getText()),
          import_react.default.createElement("span", { className: "rsbcSliderArrow", style: {
            border: `2px solid ${sliderIconColor}`,
            borderLeftColor: "transparent",
            borderBottomColor: "transparent",
            transformOrigin: "center"
          } }),
          import_react.default.createElement("span", { className: "rsbcSliderCircle", style: { background: finalSliderColor } })
        ),
        buttonChildren ? import_react.default.createElement("div", { style: {
          display: "flex",
          alignItems: "center",
          justifyContent: "center",
          height: "100%"
        } }, this.state.unlocked && buttonChildrenUnlocked ? buttonChildrenUnlocked : buttonChildren) : import_react.default.createElement("div", { className: `rsbcText ${noAnimate || this.state.unlocked || disabled ? "" : "textAnimate"}`, style: {
          color: textColor,
          width: "100%",
          "--shimmer-color": textColor === "#fff" || textColor === "white" ? "rgba(128, 128, 128, 0.8)" : "rgba(255, 255, 255, 1)"
        } }, this.getText())
      )
    );
  }
};
export {
  SwipeableButton
};
//# sourceMappingURL=react-swipeable-button.js.map
