<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Insert the rules content setting
        DB::table('settings')->insert([
            'key' => 'rules_content',
            'value' => '<h1>Rules and Terms</h1>
<p>Welcome to our platform. Please read these rules carefully before using our services.</p>

<h2>General Rules</h2>
<ul>
    <li>All users must be 18 years or older to use this service</li>
    <li>Users are responsible for maintaining the security of their accounts</li>
    <li>Sharing account credentials is strictly prohibited</li>
    <li>Any form of cheating or exploitation will result in account suspension</li>
</ul>

<h2>Payment Rules</h2>
<ul>
    <li>All transactions are final once processed</li>
    <li>Minimum deposit amount: $10</li>
    <li>Maximum deposit amount: $1000 per transaction</li>
    <li>Processing times may vary depending on payment method</li>
</ul>

<h2>Game Rules</h2>
<ul>
    <li>Fair play is mandatory</li>
    <li>No use of automated tools or bots</li>
    <li>Respect other players and staff members</li>
    <li>Follow the specific rules of each individual game</li>
</ul>

<h2>Account Management</h2>
<ul>
    <li>One account per person</li>
    <li>Keep your contact information up to date</li>
    <li>Report any suspicious activity immediately</li>
    <li>Account inactivity for 6 months may result in suspension</li>
</ul>

<h2>Contact Information</h2>
<p>If you have any questions about these rules, please contact our support team.</p>',
            'type' => 'textarea',
            'group' => 'content',
            'label' => 'Rules Content',
            'description' => 'HTML content for the rules page',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Insert the rules updated at setting
        DB::table('settings')->insert([
            'key' => 'rules_updated_at',
            'value' => now()->toDateString(),
            'type' => 'date',
            'group' => 'content',
            'label' => 'Rules Last Updated',
            'description' => 'Date when rules content was last updated',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('settings')->whereIn('key', ['rules_content', 'rules_updated_at'])->delete();
    }
};
