<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->bigInteger('invoice_id')->nullable()->after('id'); // Add invoice_id column
        });

        // Assign unique invoice IDs to existing transactions
        DB::statement('UPDATE transactions SET invoice_id = id + 100000 WHERE invoice_id IS NULL');

        // Make the column NOT NULL
        Schema::table('transactions', function (Blueprint $table) {
            $table->bigInteger('invoice_id')->unique()->nullable(false)->change();
        });
    }

    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn('invoice_id');
        });
    }
};
