<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Add currency settings
        DB::table('settings')->insert([
            [
                'key' => 'available_currencies',
                'value' => json_encode(['SATS', 'USD']),
                'type' => 'array',
                'group' => 'currency',
                'label' => 'Available Currencies',
                'description' => 'List of available currencies in the system',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'default_currency',
                'value' => 'USD',
                'type' => 'select',
                'group' => 'currency',
                'label' => 'Default Currency',
                'description' => 'Default currency for transactions',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'sats_to_usd_rate',
                'value' => '0.00034',
                'type' => 'number',
                'group' => 'currency',
                'label' => 'SATS to USD Rate',
                'description' => 'Conversion rate from SATS to USD',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down(): void
    {
        DB::table('settings')
            ->whereIn('key', ['available_currencies', 'default_currency', 'sats_to_usd_rate'])
            ->delete();
    }
}; 