<?php

namespace App\Http\Controllers;

use App\Models\Promo;
use App\Models\Setting;
use Illuminate\Http\Request;
use Inertia\Inertia;

class PromoController extends Controller
{
    public function index()
    {
        $promos = Promo::active()
            ->withinDateRange()
            ->orderBy('display_order')
            ->orderBy('created_at', 'desc')
            ->get();

        $settings = [
            'enable_redeem' => Setting::get('enable_redeem') === 'true',
        ];

        return Inertia::render('Promo', [
            'promos' => $promos,
            'settings' => $settings,
        ]);
    }
} 