<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\WalletService;
use Inertia\Inertia;

class WalletController extends Controller
{
    protected $walletService;

    public function __construct(WalletService $walletService)
    {
        $this->walletService = $walletService;
    }

    public function index()
    {
        $balance = $this->walletService->getMerchantBalance();
        $GGPayoutBalance = $this->walletService->getMerchantBalance('ggpayout');
        return Inertia::render('Admin/Wallet/Index', [
            'balance' => $balance,
            'GGPayoutBalance' => $GGPayoutBalance
        ]);
    }
} 