<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Inertia\Inertia;

class SettingController extends Controller
{
    public function index()
    {
        $settings = Setting::all()->groupBy('group');
        
        return Inertia::render('Admin/Settings/Index', [
            'settings' => $settings,
        ]);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'settings.*.key' => 'required|string',
            'settings.*.value' => 'nullable',
            'settings.*.type' => 'required|string'
        ]);

        foreach ($request->settings as $setting) {
            // Ensure array values are properly stored as JSON
            $value = $setting['type'] === 'array' 
                ? json_encode(json_decode($setting['value'])) 
                : $setting['value'];
            
            Setting::set($setting['key'], $value);
            
            // If rules content is updated, also update the rules_updated_at date
            if ($setting['key'] === 'rules_content') {
                Setting::set('rules_updated_at', now()->toDateString());
            }
        }

        return redirect()->back()->with('success', 'Settings updated successfully');
    }
} 