<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Game;
use Illuminate\Http\Request;

class GameController extends Controller
{
    public function index()
    {
        $games = Game::all();
        return inertia('Admin/Games/Index', compact('games'));
    }

    public function create()
    {
        return inertia('Admin/Games/Create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'game_name' => 'required|string|max:100',
            'game_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'status' => 'required|in:active,inactive',
        ]);

        $game = new Game();
        $game->game_name = $request->game_name;
        $game->status = $request->status;

        if ($request->hasFile('game_image')) {
            $imagePath = $request->file('game_image')->store('games', 'public');
            $game->game_image = $imagePath;
        }

        $game->save();

        return redirect()->route('admin.games.index')->with('success', 'Game added successfully.');
    }

    public function edit(Game $game)
    {
        return inertia('Admin/Games/Edit', compact('game'));
    }

    public function update(Request $request, Game $game)
    {   
        $request->validate([
            'game_name' => 'required|string|max:100',
            'game_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'status' => 'required|in:active,inactive',
        ]);

        $game->game_name = $request->game_name;
        $game->status = $request->status;

        if ($request->hasFile('game_image')) {
            $imagePath = $request->file('game_image')->store('games', 'public');
            $game->game_image = $imagePath;
        }

        $game->save();

        return redirect()->route('admin.games.index')->with('success', 'Game updated successfully.');
    }

    public function show(Game $game)
    {
        return inertia('Admin/Games/Show', compact('game'));
    }

    public function toggleStatus(Game $game)
    {
        $game->toggleStatus();

        return redirect()->route('admin.games.index')->with('success', 'Game status updated successfully.');
    }

    public function destroy(Game $game)
    {
        $game->delete();
        return redirect()->route('admin.games.index')->with('success', 'Game deleted successfully.');
    }
}