<?php

use App\Models\Log as LogModel;
use Illuminate\Support\Facades\Log;

if (!function_exists('logEvent')) {
    function logEvent($type, $source, $message, $context = [], $userId = null)
    {
        if (env('ENABLE_LOGS', false)) {
            LogModel::create([
                'type' => $type,
                'source' => $source,
                'message' => $message,
                'context' => json_encode($context),
                'ip_address' => request()->ip(),
                'user_agent' => request()->userAgent(),
                'user_id' => $userId,
            ]);
        }
    }
}
